<?php
error_reporting(E_ALL);
ini_set('display_errors', '0');

// Detect environment
if ($_SERVER['HTTP_HOST'] == "localhost") {
    define('LOCAL_MODE', true);
} else {
    define('LOCAL_MODE', false);
}

// File system path
$tmp = dirname(__FILE__);
$tmp = str_replace('\\', '/', $tmp);
$tmp = substr($tmp, 0, strrpos($tmp, '/'));
define('SITE_FS_PATH', $tmp);

// include all the library files needed here
require_once(SITE_FS_PATH."/includes/config.inc.php");
require_once(SITE_FS_PATH."/includes/funcs_lib.inc.php");
require_once(SITE_FS_PATH."/includes/funcs_cur.inc.php");

session_start();

// Current path
$CURRENT_SUB_PATH = str_replace(SITE_FS_PATH, '/', dirname($_SERVER['PHP_SELF']));

// Detect plugin
$CURRENT_PLUGIN = '';
$plugin_pos  = strpos($_SERVER['PHP_SELF'], '/'.PLUGINS_DIR.'/');
if ($plugin_pos !== false) {
    $CURRENT_PLUGIN = substr($_SERVER['PHP_SELF'], $plugin_pos + strlen(PLUGINS_DIR) + 2);
    $slash_pos = strpos($CURRENT_PLUGIN, '/');
    if ($slash_pos !== false) {
        $CURRENT_PLUGIN = substr($CURRENT_PLUGIN, 0, $slash_pos);
    }
}
define('CURRENT_PLUGIN', $CURRENT_PLUGIN);

// Script start time
if (!function_exists('getmicrotime')) {
    function getmicrotime() {
        return microtime(true);
    }
}
define('SCRIPT_START_TIME', getmicrotime());

// ✅ Magic quotes are deprecated, just trim inputs safely
if (!empty($_GET)) {
    $_GET = ms_trim($_GET);
}
if (!empty($_POST)) {
    $_POST = ms_trim($_POST);
}
if (!empty($_COOKIE)) {
    $_COOKIE = ms_trim($_COOKIE);
}

// load plugins
if ($handle = opendir(SITE_FS_PATH.'/'.PLUGINS_DIR)) { 
   while (false !== ($file = readdir($handle))) { 
       if ($file != "." && $file != "..") { 
           $curr_dir = SITE_FS_PATH.'/'.PLUGINS_DIR.'/'.$file;
           if (is_dir($curr_dir)) {
               if (file_exists($curr_dir.'/midas_plugin.php')) {
                   require_once($curr_dir.'/midas_plugin.php');
               }
           }
       } 
   } 
   closedir($handle); 
}

$BASENAME = basename($_SERVER['PHP_SELF']);

// Protect admin pages
$PHP_SELF = $_SERVER['PHP_SELF'];
$admin_pos  = strpos($PHP_SELF, '/'.ADMIN_DIR.'/');
if ($admin_pos !== false) {
    protect_admin_page(); // check login session
}

// Admin email
$AdminEmail = db_scalar("SELECT admin_email FROM tbl_admin WHERE admin_id='1'");
$_SESSION['ADMIN_EMAIL'] = $AdminEmail;

// Update inactive members (example, commented)
// $previous_datetime = date("Y-m-d H:i:s", strtotime("-1 day"));
// db_query("UPDATE ques_questions SET user_online_status='No' WHERE user_online_date <= '$previous_datetime'");

define('ACCESS_ID',"303");
?>
